/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.config.handler.CLHDisplay;
import frc.emul.config.handler.CLHShaderKernel;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.emul.config.handler.ShaderLoaderContext;
import frc.util.xml.XMLLoaderHandler;
import frc.util.xml.XMLLoaderHandlerFactor;
import frc.util.xml.XMLLoaderHandlerValue;
import org.xml.sax.Attributes;

public class CLHShaders
extends ConfigLoaderHandler {
    CfgItemShaderGlow shader;
    final Level level;

    CLHShaders(ShaderLoaderContext shaderLoaderContext) {
        super(shaderLoaderContext);
        this.level = Level.ROOT;
    }

    CLHShaders(CLHDisplay cLHDisplay) {
        super(cLHDisplay);
        this.level = Level.ROOT;
    }

    private CLHShaders(CLHShaders cLHShaders, Level level) {
        super(cLHShaders);
        this.level = level;
    }

    public void pushed(Attributes attributes) {
        this.shader = this.getConfig().options.glowShader;
        if (Level.SHADER == this.level) {
            String string = attributes.getValue("id");
            if (string == null) {
                throw new RuntimeException("Empty shader ID");
            }
            if (!"glow".equalsIgnoreCase(string)) {
                throw new RuntimeException("Unknown shader ID [" + string + "]");
            }
            this.shader.passes = CLHShaders.loadInt(attributes, "passes", this.shader.passes, 1, Integer.MAX_VALUE);
            this.shader.active = CLHShaders.loadBool(attributes, "active", this.shader.active);
        } else if (Level.BUFFER == this.level) {
            this.shader.isBufferFixedSize = CLHShaders.loadBool(attributes, "fixed", this.shader.isBufferFixedSize);
            this.shader.bufferSizeFactor = CLHShaders.loadFloat(attributes, "factor", this.shader.bufferSizeFactor, 0.0f, 1.0f);
            this.shader.bufferFixedHeight = CLHShaders.loadInt(attributes, "fixedHeight", this.shader.bufferFixedHeight, 32, Integer.MAX_VALUE);
            this.shader.bufferFixedWidth = CLHShaders.loadInt(attributes, "fixedWidth", this.shader.bufferFixedWidth, 25, Integer.MAX_VALUE);
        }
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        switch (this.level) {
            case ROOT: {
                if (!string.equals("shader")) break;
                return new CLHShaders(this, Level.SHADER);
            }
            case SHADER: {
                if (string.equals("attenuation")) {
                    return this.createAttenuationChild();
                }
                if (string.equals("flickering")) {
                    return this.createFlickeringChild();
                }
                if (string.equals("kernel")) {
                    return new CLHShaderKernel(this);
                }
                if (string.equals("gains")) {
                    return new CLHShaders(this, Level.GAINS);
                }
                if (string.equals("info")) {
                    return new CLHShaders(this, Level.INFO);
                }
                if (!string.equals("bufferSize")) break;
                return new CLHShaders(this, Level.BUFFER);
            }
            case GAINS: {
                if (string.equals("horizontal")) {
                    return this.createGainChild("hGain", "hGainFactor");
                }
                if (!string.equals("vertical")) break;
                return this.createGainChild("vGain", "vGainFactor");
            }
            case INFO: {
                if (string.equals("description")) {
                    return this.createDescriptionChild();
                }
                if (!string.equals("author")) break;
                return this.createAuthorChild();
            }
        }
        return super.getChildHandler(string, attributes);
    }

    private XMLLoaderHandler createFlickeringChild() {
        return new XMLLoaderHandlerFactor(this, (Object)this.shader, "flickering", "flickeringFactor", 0.0f, 1.0f);
    }

    private XMLLoaderHandler createAttenuationChild() {
        return new XMLLoaderHandlerFactor(this, (Object)this.shader, "attenuation", "attenuationFactor", 1.0f, 10.0f);
    }

    private XMLLoaderHandler createGainChild(String string, String string2) {
        return new XMLLoaderHandlerFactor(this, (Object)this.shader, string, string2, 0.0f, Float.MAX_VALUE);
    }

    private XMLLoaderHandler createDescriptionChild() {
        return new XMLLoaderHandlerValue(this){

            protected void handleValue(String string) {
                CLHShaders.this.shader.description = string;
            }
        };
    }

    private XMLLoaderHandler createAuthorChild() {
        return new XMLLoaderHandlerValue(this){

            protected void handleValue(String string) {
                CLHShaders.this.shader.author = string;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        ROOT,
        SHADER,
        GAINS,
        INFO,
        BUFFER;

    }
}

